% "Olfactory behaviors assayed by computer tracking of Drosophila in a 
% four-quadrant olfactometer".
% 
% AUTHORS: 
% Chun-Chieh Lin, Olena Riabinina, Christopher J.Potter
% 
% The Solomon H. Snyder Department of Neuroscience, Center for Sensory 
% Biology, Johns Hopkins University School of Medicine, 
% Baltimore, MD 21205, USA. cpotter@jhmi.edu

% This function formats a graph and saves it in jpeg format, with a name
% provided in a variable pref

function [a]=FormatAndSaveFig(pref)


%==== find all graphs on the current axis===
h=findobj('Type','line');

%=== set width of all graphs===
set(h,'LineWidth',1);

%=== set tick size and direction
set(gca,'TickDir','out','Box','off','TickLength',[0.04 0.1])

%== set font of the text and axis labels
set(gca, 'FontName', 'Arial', 'FontSize', 12)
set(get(gca,'XLabel'), 'FontName', 'Arial', 'FontSize', 12)
set(get(gca,'YLabel'), 'FontName', 'Arial', 'FontSize', 12)
set(get(gca,'title'), 'FontName', 'Arial', 'FontSize', 12)

%=== save as jpeg file
temp=[pref '.jpeg'];
set(gcf, 'PaperPositionMode', 'auto');
print ('-djpeg', '-r600', temp)